//
//  ViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 13/06/2022.
//

import UIKit

class ActivationViewController: BaseViewController {
    
    
    @IBOutlet weak var activationButton: UIButton!
    @IBOutlet weak var activationCodeField: UITextField!
    @IBOutlet weak var activationTitle: UILabel!
    
    fileprivate var activationCode: String?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        
        if InweboService.sharedInstance.isActivated() {
            startDemo()
        }
    }
    
    func startDemo() {
        if let delegate = UIApplication.shared.delegate as? AppDelegate {
            delegate.startDemo(from: self)
        }
    }
    
    func handleActivationProcess(code: String) {
        activationCodeField.text = ""
        activationCodeField.isSecureTextEntry = true
        
        let pinMode = InweboService.sharedInstance.getPinMode()
        if pinMode == IW_PINMODE_NONE {
            finalizeActivation(code: code, pin: "")
        } else if pinMode == IW_PINMODE_CURRENT {
            self.activationTitle.text = "Enter PIN:"
        } else {
            self.activationTitle.text = "Define PIN:"
        }
    }
    
    @IBAction func sendActivationCode(_ sender: Any) {
        if let code = activationCodeField.text {
            if let activationCode = activationCode  {
                // Finalization
                finalizeActivation(code: activationCode, pin: code)
            } else {
                // Start
                let result = InweboService.sharedInstance.sendActivationCode(code: code)
                if result == 0 {
                    self.activationCode = code
                    handleActivationProcess(code: code)
                } else {
                    self.showAlert(title: "Error", message: "Activation failed")
                }
            }
        } else {
            // KO
            self.showAlert(title: "Error", message: "Please fill the activation code field")
        }
    }
    
    func finalizeActivation(code: String, pin: String) {
        let result = InweboService.sharedInstance.finalizeActivationCode(code: code, pin: pin)
        if result == 0 {
            startDemo()
        } else {
            self.showAlert(title: "Error", message: "Activation failed")
        }
    }
    
}

